// PIODlg.cpp : implementation file
//

#include "stdafx.h"
#include "PIO.h"
#include "PIODlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPIODlg dialog

CPIODlg::CPIODlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPIODlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPIODlg)
	m_display = 0;
	m_outEnable = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPIODlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPIODlg)
	DDX_Control(pDX, IDC_WRITE, m_writeButton);
	DDX_Text(pDX, IDC_EDIT2, m_display);
	DDX_Check(pDX, IDC_OUTPUT, m_outEnable);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPIODlg, CDialog)
	//{{AFX_MSG_MAP(CPIODlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_QUIT, OnQuit)
	ON_BN_CLICKED(IDC_OUTPUT, OnOutput)
	ON_BN_CLICKED(IDC_READ, OnRead)
	ON_BN_CLICKED(IDC_WRITE, OnWrite)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPIODlg message handlers

BOOL CPIODlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_logicalDevice=0; //This is the DriverLINX logical device number (Config Panel)
	m_logicalChannel=0; //This is the logical channel to be used
	m_DriverInstance=OpenDriverLINX(m_hWnd,""); //Opens DriverLINX
	/*
       Pass in drive name to avoid the Open Driver dialog:
	   "kmbpio" for ISA bus PIO cards
	   "kpcipio" for KPCI-PIO24 or KPCI-PIO96
	   "kpci3160" for KPCI-3160
    */
	m_pSR=(DL_ServiceRequest*) new DL_ServiceRequest; //Allocate memory for the service request
	memset(m_pSR,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*m_pSR);
	m_pSR->operation=INITIALIZE;
	m_pSR->device=m_logicalDevice;
	m_pSR->mode=OTHER;
	m_pSR->subsystem=DEVICE;
	m_pSR->hWnd=m_hWnd; //the service request needs to have a handle to the dialog window, which is already defined in m_hWnd
	// use GetDesktopWindow() if making a console application AND not using messages
	DriverLINX(m_pSR);  //execute the service request
	showMessage(m_pSR); //show errors, if any.
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPIODlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPIODlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CPIODlg::showMessage(DL_ServiceRequest *pSR)
{
	pSR->operation=MESSAGEBOX;
	DriverLINX(pSR);
}

void CPIODlg::OnQuit() 
{
	// TODO: Add your control notification handler code here
	delete m_pSR;
	m_pSR=NULL;
	CloseDriverLINX(m_DriverInstance);
	m_DriverInstance=NULL;
	OnOK();
	
}

void CPIODlg::OnOutput() 
{
	// this is a configure operation to assign the channel for
	// output or input direction dynamically

	UpdateData(TRUE); //Get the current values of the controls
	memset(m_pSR,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*m_pSR);
	m_pSR->operation=CONFIGURE;
	m_pSR->mode=OTHER;
	m_pSR->device=m_logicalDevice;
	if(m_outEnable == TRUE)
	{
		m_pSR->subsystem=DO; //make the channel an output
		m_writeButton.EnableWindow(TRUE); 
	}
	else
	{
		m_pSR->subsystem=DI; //make the channel an input
		m_writeButton.EnableWindow(FALSE); //disable the write functionality if not an output
	}
	m_pSR->timing.typeEvent=DIOSETUP;
	m_pSR->timing.u.diSetup.channel=m_logicalChannel;
	m_pSR->timing.u.diSetup.mode=DIO_BASIC;
	m_pSR->hWnd=m_hWnd;
	DriverLINX(m_pSR);
	showMessage(m_pSR);
	
}

void CPIODlg::OnRead() 
{
	// read the channel and display the result
	memset(m_pSR,0,sizeof(DL_ServiceRequest));  // reset all members to zero
	DL_SetServiceRequestSize(*m_pSR);
	m_pSR->device=m_logicalDevice;
	m_pSR->subsystem=DI;
	m_pSR->operation=START;
	m_pSR->mode=POLLED;
	m_pSR->channels.nChannels=1;
	m_pSR->channels.chanGain[0].channel=m_logicalChannel;
	m_pSR->status.typeStatus=IOVALUE;
	m_pSR->hWnd=m_hWnd;
	DriverLINX(m_pSR);
	showMessage(m_pSR);
	m_display=m_pSR->status.u.ioValue;
	UpdateData(FALSE);
	
}

void CPIODlg::OnWrite() 
{
	// write a value between 0 and 255 to the channel
	// the configure operation will have been carried out first
	UpdateData(TRUE);
	memset(m_pSR,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*m_pSR);
	m_pSR->device=m_logicalDevice;
	m_pSR->subsystem=DO;
	m_pSR->mode=POLLED;
	m_pSR->operation=START;
	m_pSR->channels.nChannels=1;
	m_pSR->channels.chanGain[0].channel=m_logicalChannel;
	m_pSR->status.typeStatus=IOVALUE;
	m_pSR->status.u.ioValue=m_display;
	m_pSR->hWnd=m_hWnd;
	DriverLINX(m_pSR);
	showMessage(m_pSR);
}

/*

  Written in Microsoft VC++ 6.0 Standard Edition

  Tested with KPCI-PIO24 in Win2K SP1

  This program opens the driver for a device 0 board.

  It allows digital input channel 0 to be read.

  It will also configure digital input channel 0 for output
  and then allow values to be written to it.

  It is appropriate for any board that has an 8255 or an emulated 8255 chip such as:
  PIO-12
  PIO-24
  PIO-96
  PIO-96J
  PIO-SSR-xx
  KPCI-PIO24
  KPCI-PIO96
  KPCI-3160

*/